# coding: utf-8
# SCRIPT description
# CREATION DATA : 02/04/2019
# WRITTEN BY : Maurizio Abbate
# RELEASE 1.0.2
# RELEASE DATA : 21/05/2020
# PURPOSE : Create box segments freely orientated on XY
#
# NOTE : 
#
# Tested for V4d Release : 3.1.4 / 3.2
#
# ------------------------------ External Package Import ------------------------------ 
import math as Math
import time
import arivis
import arivis_core as core
import arivis_objects as objects
# ------------------------------  End of external Package Import ------------------------------ 
#
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ USER SETTINGS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
TAG_DESCRIPTOR = "Manual"        #Cell Manual"
TAG_DESCRIPTOR_OUT = "Script"        #Cell Manual"
COMPUTE_MAIN_BOX = False
FIRST_PLANE = 3        # -1 == bottom plane
LAST_PLANE = 10       # -1 == top plane
SIZE_IN_VOXELS = True
SIZE_BOX_HOR = 5.0      # used if SIZE_IN_VOXELS == True, expressed in um
SIZE_BOX_VER = 10.0      # used if SIZE_IN_VOXELS == True, expressed in um
NUM_BOX_LENGHT = 3     #NUM_BOX_VERT
NUM_BOX_WIDTH = 2       #NUM_BOX_HORIZ
NUM_BOX_DEPTH = 2       # Currently Not Used
# @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ END USER SETTINGS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
#
#
# ------------------------------ Global variables  ------------------------------ 
#   DON'T MODIFY the following variables
# ------------------------------------------------------------------------------
FEATURE_BB_CENTER = "Center of Bounding Box"
SUB_FEATURE_BB_CENTER_NUM  = 6
SUB_FEATURE_BB_XP  = 3
SUB_FEATURE_BB_YP  = 4
SUB_FEATURE_BB_ZP  = 5
# ------------------------------------------------------------------------------
FEATURE_PLANES = "Plane"
SUB_FEATURE_PLANES_NUM  = 3
SUB_FEATURE_PLANES_FIRST  = 0
SUB_FEATURE_PLANES_LAST = 1
SUB_FEATURE_PLANES_COUNT  = 2
# ------------------------------------------------------------------------------
FEATURE_BB_SIZE = "Bounding Box (Pixel)"
SUB_FEATURE_BB_SIZE_NUM  = 9
SUB_FEATURE_BB_SIZEXP  = 6
SUB_FEATURE_BB_SIZEYP  = 7
SUB_FEATURE_BB_SIZEZP  = 8
# ------------------------------------------------------------------------------
FEATURE_BB_CENTER = "Center of Bounding Box"
SUB_FEATURE_CENTER_NUM  = 6
SUB_FEATURE_CENTER_XP  = 3
SUB_FEATURE_CENTER_YP  = 4
SUB_FEATURE_CENTER_ZP  = 5
# ------------------------------------------------------------------------------
FEATURE_2D_BB = "2D Oriented Bounds"
SUB_FEATURE_2D_BB_NUM  = 7
SUB_FEATURE_2D_SHORT  = 0
SUB_FEATURE_2D_LONG  = 1
SUB_FEATURE_2D_ANGLE  = 4
SUB_FEATURE_2D_X  = 5
SUB_FEATURE_2D_Y  = 6
# ------------------------------------------------------------------------------
UNIT_COEFF = 1000000.0
POLYGONE_ENTRIES = 4
# ------------------------------------------------------------------------------
BOX_X = 0
BOX_Y = 1
BOX_Z = 2
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Enviroment
# ------------------------------------------------------------------------------
def MA_Get_Enviroment():
  # ------------------------------------------------------------------------------
  # return the viewer and the imageset  objects
  # ------------------------------------------------------------------------------
  viewer = arivis.App.get_active_viewer()
  imageset = viewer.get_imageset()
  if None == imageset :
    print "No Image Set open" 
    return viewer,None  
  # ------------------------------------------------------------------------------ 
  return viewer,imageset
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Get_Enviroment 
# ------------------------------------------------------------------------------ 
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Get_Storage
# ------------------------------------------------------------------------------
def MA_Get_Storage(imageset):
  # ------------------------------------------------------------------------------
  # return the storage object
  # ------------------------------------------------------------------------------
  if None == imageset :
    print "No Image Set open" 
    return None  
  # ------------------------------------------------------------------------------
  document = imageset.get_document()
  if None == document :
    print "No Document open" 
    return None
  # ------------------------------------------------------------------------------
  store = document.get_store(imageset, objects.Store.DOCUMENT_STORE)
  if None == store :
    print "No Measurements availble" 
    return None
  # ------------------------------------------------------------------------------
  # Get the full object's ID list - if the list's lenght is == 0 no storage 
  # ------------------------------------------------------------------------------
  IdList = store.get_object_ids("")
  #print "lenght " + str(len(IdList))   
  #------------------------------------------------------------------------------  
  if 0 == len(IdList):
    print "No Objects" 
    return None
  # ------------------------------------------------------------------------------
  #print "Get_Storage - OK " 
  return store
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Get_Storage
# ------------------------------------------------------------------------------
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Get_Document
# ------------------------------------------------------------------------------
def MA_Get_Document(imageset):
  # ------------------------------------------------------------------------------
  # return the document object
  # ------------------------------------------------------------------------------
  if None == imageset :
    print "No Image Set open" 
    return None  
  # ------------------------------------------------------------------------------
  document = imageset.get_document()
  if None == document :
    print "No Document open" 
    return None
  # ------------------------------------------------------------------------------
  return document
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Get_Document
# ------------------------------------------------------------------------------
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object
# ------------------------------------------------------------------------------
def Get_Object(store,IdOBJ):
  # ------------------------------------------------------------------------------
  # return the object centroid (3D_Bounding Box - pixels)
  # NO_Error , Point3D(X ,Y, Z)
  # strTAG
  # ------------------------------------------------------------------------------
  if None == store :
   print "No Measurements available" 
   return None 
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None == object1:  
    # ------------------------------------------------------------------------------
    print "No Segment available" 
    return None
  else:
    return object1
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object
# ------------------------------------------------------------------------------ 
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object_Plane_Range
# ------------------------------------------------------------------------------
def Get_Object_Plane_Range(store,IdOBJ,strTAG):
  # ------------------------------------------------------------------------------
  # return : the object first / last  planes 
  # order  : Point2D(first ,last)
  # ------------------------------------------------------------------------------
  if None == store :
   print "No Measurements available" 
   return core.Point2D(-1,-1)    
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None != object1:  
    # ------------------------------------------------------------------------------
    IDobject1 = object1.get_id()  
    TAgObject1 = object1.get_tags()
    if strTAG in TAgObject1:
      # ------------------------------------------------------------------------------    
      FeatureDesc = store.get_feature_descriptor(FEATURE_PLANES)
      # ------------------------------------------------------------------------------
      #     get_feature_descriptor - "Center of Bounding Box" - single features (XYZ, X(pix),Y(pix),Z(pix)
      #     objects.ValueDescriptor.TYPE_FLOAT
      # ------------------------------------------------------------------------------    
      FeatureValue = FeatureDesc.get_values() 
      if SUB_FEATURE_PLANES_NUM == len(FeatureValue):
        # ------------------------------------------------------------------------------            
        FeatureValue1 = FeatureValue[SUB_FEATURE_PLANES_FIRST].get_name()
        FeatureValue2 = FeatureValue[SUB_FEATURE_PLANES_LAST].get_name()
        FeatureValue3 = FeatureValue[SUB_FEATURE_PLANES_COUNT].get_name()
        Feature1 = store.get_feature_for_object(FeatureDesc,object1)
        Featurevalue_X = int(Feature1.get_value(FeatureValue1).replace(',','.'))
        Featurevalue_Y = int(Feature1.get_value(FeatureValue2).replace(',','.'))
        Featurevalue_Z = int(Feature1.get_value(FeatureValue3).replace(',','.'))
        # ------------------------------------------------------------------------------ 
        return core.Point3D(Featurevalue_X,Featurevalue_Y)
        # ------------------------------------------------------------------------------ 
      else:
        print "Error SUB_FEATURE_PLANES_NUM " + str(len(FeatureValue))      
        return core.Point2D(-1,-1) 
      # ------------------------------------------------------------------------------
    else:
      print "The tag " + strTAG + " does not exist, using " + str(TAgObject1[0]) + " instead" 
      return core.Point2D(-1,-1) 
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object_Plane_Range
# ------------------------------------------------------------------------------ 
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object_BB_Centroid
# ------------------------------------------------------------------------------
def Get_Object_BB_Centroid(store,IdOBJ,strTAG):
  # ------------------------------------------------------------------------------
  # return the object centroid (3D_Bounding Box - pixels)
  # NO_Error , Point3D(X ,Y, Z)
  # strTAG
  # ------------------------------------------------------------------------------
  if None == store :
   print "No Measurements available" 
   return core.Point3D(-1,-1,-1)       
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None != object1:  
    # ------------------------------------------------------------------------------
    IDobject1 = object1.get_id()  
    TAgObject1 = object1.get_tags()
    #print " TAGs " + str(TAgObject1) + " ID " + str(IDobject1)
    if strTAG in TAgObject1:
      # ------------------------------------------------------------------------------
      #  get some ridondant info
      # ------------------------------------------------------------------------------     
      NameObject1 = object1.get_name()
      # ------------------------------------------------------------------------------    
      FeatureDesc = store.get_feature_descriptor(FEATURE_BB_CENTER)
      # ------------------------------------------------------------------------------    
      FeatureValue = FeatureDesc.get_values()
      if SUB_FEATURE_BB_CENTER_NUM == len(FeatureValue):
        # ------------------------------------------------------------------------------            
        FeatureValue1 = FeatureValue[SUB_FEATURE_BB_XP].get_name()
        FeatureValue2 = FeatureValue[SUB_FEATURE_BB_YP].get_name()
        FeatureValue3 = FeatureValue[SUB_FEATURE_BB_ZP].get_name()
        FeatureValueType = FeatureValue[SUB_FEATURE_BB_XP].get_type()
        Feature1 = store.get_feature_for_object(FeatureDesc,object1)
        Featurevalue_X = int(float(Feature1.get_value(FeatureValue1).replace(',','.')))
        Featurevalue_Y = int(float(Feature1.get_value(FeatureValue2).replace(',','.')))
        Featurevalue_Z = int(float(Feature1.get_value(FeatureValue3).replace(',','.')))
        # ------------------------------------------------------------------------------ 
        return core.Point3D(Featurevalue_X,Featurevalue_Y,Featurevalue_Z)
        # ------------------------------------------------------------------------------ 
      else:
        print "Error SUB_FEATURE_BB_CENTER_NUM " + str(len(FeatureValue))
        return core.Point3D(-1,-1,-1)     
      # ------------------------------------------------------------------------------
    else:
      print "The tag " + strTAG + " does not exist, using " + str(TAgObject1[0]) + " instead"
      return core.Point3D(-1,-1,-1)
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object_BB_Centroid
# ------------------------------------------------------------------------------ 
#
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object_2DBB_Centroid
# ------------------------------------------------------------------------------
def Get_Object_2DBB_Centroid(imageset,store,IdOBJ,strTAG,pixel):
  # ------------------------------------------------------------------------------
  # return : the object BB diameters (2D Oriented Bounds")
  # order  : short , long
  # ------------------------------------------------------------------------------
  if None == store or None == imageset:
   print "No Measurements available" 
   return core.Point2D(-1,-1)    
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None != object1:  
    # ------------------------------------------------------------------------------
    IDobject1 = object1.get_id()  
    TAgObject1 = object1.get_tags()
    if strTAG in TAgObject1:
      # ------------------------------------------------------------------------------    
      FeatureDesc = store.get_feature_descriptor(FEATURE_2D_BB)
      # ------------------------------------------------------------------------------
      #     get_feature_descriptor - "Center of Bounding Box" - single features (XYZ, X(pix),Y(pix),Z(pix)
      #     objects.ValueDescriptor.TYPE_FLOAT
      # ------------------------------------------------------------------------------    
      FeatureValue = FeatureDesc.get_values()
      if SUB_FEATURE_2D_BB_NUM == len(FeatureValue):
        # ------------------------------------------------------------------------------            
        FeatureValue1 = FeatureValue[SUB_FEATURE_2D_X].get_name()
        FeatureValue2 = FeatureValue[SUB_FEATURE_2D_Y].get_name()
        Feature1 = store.get_feature_for_object(FeatureDesc,object1)
        #print "Angle X : " + Feature1.get_value(FeatureValue1) + "  Angle Y : " + Feature1.get_value(FeatureValue2) + "  Angle Z : " + Feature1.get_value(FeatureValue3)
        Featurevalue_X = float(Feature1.get_value(FeatureValue1).replace(',','.'))
        Featurevalue_Y = float(Feature1.get_value(FeatureValue2).replace(',','.'))
        if True==pixel:
          # ------------------------------------------------------------------------------                      
          Featurevalue_X = (Featurevalue_X * UNIT_COEFF) / max(0.0001,imageset.get_pixel_width()) 
          Featurevalue_Y = (Featurevalue_Y * UNIT_COEFF) / max(0.0001,imageset.get_pixel_width())
        # ------------------------------------------------------------------------------ 
        return core.Point2D(int(Featurevalue_X),int(Featurevalue_Y)) 
        # ------------------------------------------------------------------------------ 
      else:
        print "Error SUB_FEATURE_2D_BB_NUM " + str(len(FeatureValue))      
        return core.Point2D(-1,-1)
      # ------------------------------------------------------------------------------
    else:
      print "The tag " + strTAG + " does not exist, using " + str(TAgObject1[0]) + " instead" 
      return core.Point2D(-1,-1)
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object_2DBB_Centroid
# ------------------------------------------------------------------------------ 
#
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object_2DBB_Size
# ------------------------------------------------------------------------------
def Get_Object_2DBB_Size(imageset,store,IdOBJ,strTAG,pixel):
  # ------------------------------------------------------------------------------
  # return : the object BB diameters (2D Oriented Bounds")
  # order  : short , long
  # ------------------------------------------------------------------------------
  if None == store or None == imageset:
   print "No Measurements available" 
   return 0.0,0.0  
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None != object1:  
    # ------------------------------------------------------------------------------
    IDobject1 = object1.get_id()  
    TAgObject1 = object1.get_tags()
    if strTAG in TAgObject1:
      # ------------------------------------------------------------------------------    
      FeatureDesc = store.get_feature_descriptor(FEATURE_2D_BB)
      # ------------------------------------------------------------------------------
      #     get_feature_descriptor - "Center of Bounding Box" - single features (XYZ, X(pix),Y(pix),Z(pix)
      #     objects.ValueDescriptor.TYPE_FLOAT
      # ------------------------------------------------------------------------------    
      FeatureValue = FeatureDesc.get_values()
      if SUB_FEATURE_2D_BB_NUM == len(FeatureValue):
        # ------------------------------------------------------------------------------            
        FeatureValue1 = FeatureValue[SUB_FEATURE_2D_SHORT].get_name()
        FeatureValue2 = FeatureValue[SUB_FEATURE_2D_LONG].get_name()
        Feature1 = store.get_feature_for_object(FeatureDesc,object1)
        #print "Angle X : " + Feature1.get_value(FeatureValue1) + "  Angle Y : " + Feature1.get_value(FeatureValue2) + "  Angle Z : " + Feature1.get_value(FeatureValue3)
        Featurevalue_SHORT = float(Feature1.get_value(FeatureValue1).replace(',','.'))
        Featurevalue_LONG = float(Feature1.get_value(FeatureValue2).replace(',','.'))
        if True==pixel:
          # ------------------------------------------------------------------------------                      
          Featurevalue_LONG = (Featurevalue_LONG * UNIT_COEFF) / max(0.0001,imageset.get_pixel_width()) 
          Featurevalue_SHORT = (Featurevalue_SHORT * UNIT_COEFF) / max(0.0001,imageset.get_pixel_width())
        # ------------------------------------------------------------------------------ 
        return Featurevalue_SHORT,Featurevalue_LONG
        # ------------------------------------------------------------------------------ 
      else:
        print "Error SUB_FEATURE_2D_BB_NUM " + str(len(FeatureValue))      
        return 0.0,0.0
      # ------------------------------------------------------------------------------
    else:
      print "The tag " + strTAG + " does not exist, using " + str(TAgObject1[0]) + " instead" 
      return 0.0,0.0
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object_2DBB_Size
# ------------------------------------------------------------------------------ 
#
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object_2DBB_Angle
# ------------------------------------------------------------------------------
def Get_Object_2DBB_Angle(store,IdOBJ,strTAG):
  # ------------------------------------------------------------------------------
  # return : the object BB angles (3D Oriented Bounds")
  # order  : angleX ,angleY, angleZ
  # ------------------------------------------------------------------------------
  if None == store :
   print "No Measurements available" 
   return 0.0
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None != object1:  
    # ------------------------------------------------------------------------------
    IDobject1 = object1.get_id()  
    TAgObject1 = object1.get_tags()
    if strTAG in TAgObject1:
      # ------------------------------------------------------------------------------    
      FeatureDesc = store.get_feature_descriptor(FEATURE_2D_BB)
      # ------------------------------------------------------------------------------
      #     get_feature_descriptor - "Center of Bounding Box" - single features (XYZ, X(pix),Y(pix),Z(pix)
      #     objects.ValueDescriptor.TYPE_FLOAT
      # ------------------------------------------------------------------------------    
      FeatureValue = FeatureDesc.get_values()
      if SUB_FEATURE_2D_BB_NUM == len(FeatureValue):
        # ------------------------------------------------------------------------------            
        FeatureValue1 = FeatureValue[SUB_FEATURE_2D_ANGLE].get_name()
        Feature1 = store.get_feature_for_object(FeatureDesc,object1)
        #print "Angle X : " + Feature1.get_value(FeatureValue1) + "  Angle Y : " + Feature1.get_value(FeatureValue2) + "  Angle Z : " + Feature1.get_value(FeatureValue3)
        Featurevalue_X = float(Feature1.get_value(FeatureValue1).replace(',','.'))
        # ------------------------------------------------------------------------------ 
        return Featurevalue_X
        # ------------------------------------------------------------------------------ 
      else:
        print "Error SUB_FEATURE_2D_BB_NUM " + str(len(FeatureValue))      
        return 0.0
      # ------------------------------------------------------------------------------
    else:
      print "The tag " + strTAG + " does not exist, using " + str(TAgObject1[0]) + " instead" 
      return 0.0
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object_2DBB_Angle
# ------------------------------------------------------------------------------ 
#
# ------------------------------ Script body ----------------------------------- 
# Function : Get_Object_BB_Size
# ------------------------------------------------------------------------------
def Get_Object_BB_Size(store,IdOBJ,strTAG):
  # ------------------------------------------------------------------------------
  # return : the object BB dimensions (3D_Bounding Box - pixels)
  # order  : Point3D(sizeX ,sizeY, sizeZ)
  # ------------------------------------------------------------------------------
  if None == store :
   print "No Measurements available" 
   return core.Point3D(-1,-1,-1)     
  # ------------------------------------------------------------------------------
  object1 = store.get_object(IdOBJ,True) 
  if None != object1:  
    # ------------------------------------------------------------------------------
    IDobject1 = object1.get_id()  
    TAgObject1 = object1.get_tags()
    if strTAG in TAgObject1:
      # ------------------------------------------------------------------------------    
      FeatureDesc = store.get_feature_descriptor(FEATURE_BB_SIZE)
      # ------------------------------------------------------------------------------
      #     get_feature_descriptor - "Center of Bounding Box" - single features (XYZ, X(pix),Y(pix),Z(pix)
      #     objects.ValueDescriptor.TYPE_FLOAT
      # ------------------------------------------------------------------------------    
      FeatureValue = FeatureDesc.get_values()
      if SUB_FEATURE_BB_SIZE_NUM == len(FeatureValue):
        # ------------------------------------------------------------------------------            
        FeatureValue1 = FeatureValue[SUB_FEATURE_BB_SIZEXP].get_name()
        FeatureValue2 = FeatureValue[SUB_FEATURE_BB_SIZEYP].get_name()
        FeatureValue3 = FeatureValue[SUB_FEATURE_BB_SIZEZP].get_name()
        Feature1 = store.get_feature_for_object(FeatureDesc,object1)
        Featurevalue_X = int(Feature1.get_value(FeatureValue1))
        Featurevalue_Y = int(Feature1.get_value(FeatureValue2))
        Featurevalue_Z = int(Feature1.get_value(FeatureValue3))
        # ------------------------------------------------------------------------------ 
        return core.Point3D(Featurevalue_X,Featurevalue_Y,Featurevalue_Z)
        # ------------------------------------------------------------------------------ 
      else:
        print "Error SUB_FEATURE_BB_SIZE_NUM " + str(len(FeatureValue))      
        return core.Point3D(-1,-1,-1)
      # ------------------------------------------------------------------------------
    else:
      print "The tag " + strTAG + " does not exist, using " + str(TAgObject1[0]) + " instead" 
      return core.Point3D(-1,-1,-1)
# ------------------------------ Script body ----------------------------------- 
# End Function : Get_Object_BB_Size
# ------------------------------------------------------------------------------ 
#
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Compute_Size_Boxes  DELETE
# ------------------------------------------------------------------------------
def MA_Compute_Size_Boxes(Horiz,Vert,firstZ,lastZ,lenght,width,dept):
  # ------------------------------------------------------------------------------
  # compute the # of boxes on all the axises
  # retrun : Hor,Ver,Dep
  # ------------------------------------------------------------------------------
  if  0>=Horiz or 0>=Vert:
    return 1,1,1
  # ------------------------------------------------------------------------------
  if 0>=lenght:
    lenght = 1
  if 0>=width:
    width = 1
  if 0>=dept:
    dept = 1      
  # ------------------------------------------------------------------------------  
  HorizBoxSize = int(Horiz/lenght)
  VertBoxSize = int(Vert/width)
  PlaneRange = int(abs(lastZ-firstZ)/dept)  
  # ------------------------------------------------------------------------------
  return HorizBoxSize,VertBoxSize,PlaneRange
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Compute_Size_Boxes
# ------------------------------------------------------------------------------  
#
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Compute_SizeXY_Boxes
# ------------------------------------------------------------------------------
def MA_Compute_SizeXY_Boxes(Horiz,Vert,lenght,width):
  # ------------------------------------------------------------------------------
  # compute the # of boxes on all the axises
  # retrun : Hor,Ver,Dep
  # ------------------------------------------------------------------------------
  if  0>=Horiz or 0>=Vert:
    return 1,1
  # ------------------------------------------------------------------------------
  if 0>=lenght:
    lenght = 1
  if 0>=width:
    width = 1     
  # ------------------------------------------------------------------------------  
  HorizBoxSize = int(Horiz/lenght)
  VertBoxSize = int(Vert/width) 
  # ------------------------------------------------------------------------------     
  print "HorizBoxSize: " + str(HorizBoxSize) + " VertBoxSize: " + str(VertBoxSize) 
  #print "Horiz: " + str(Horiz) + " lenght: " + str(lenght)
  #print "Vert: " + str(Vert) + " width: " + str(width)  
  # ------------------------------------------------------------------------------
  return HorizBoxSize,VertBoxSize
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Compute_SizeXY_Boxes
# ------------------------------------------------------------------------------  
#
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Compute_MetricSizeXY_Boxes
# ------------------------------------------------------------------------------
def MA_Compute_MetricSizeXY_Boxes(imageset):
  # ------------------------------------------------------------------------------
  # get the numbers of boxes in all the dimension
  # ------------------------------------------------------------------------------
  if None == imageset:
    print "No ImageSet available [MA_Compute_MetricSizeXY_Boxes]" 
    return 0,0   
  # ------------------------------------------------------------------------------    
  unitX = imageset.get_pixel_width()
  if unitX == 0.0:
    unitX = 1.0
  unitY = imageset.get_pixel_height()  
  if unitY == 0.0:
    unitY = 1.0
  unitZ = imageset.get_pixel_depth() 
  if unitZ == 0.0:
    unitZ = 1.0     
  print "unitX: " + str(unitX) + " unitY: " + str(unitY)    
  # ------------------------------------------------------------------------------  
  pixelsX = SIZE_BOX_HOR/ unitX
  pixelsY = SIZE_BOX_VER / unitY  
  # ------------------------------------------------------------------------------    
  return int(pixelsX),int(pixelsY)
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Compute_MetricSizeXY_Boxes
# ------------------------------------------------------------------------------ 
#
#
# ------------------------------ Script body ----------------------------------- 
# Function : MA_Compute_Multi_Boxes
# ------------------------------------------------------------------------------
def MA_Compute_Multi_Boxes(imageset,Store,Centroide,BBox,firstP,lastP, Ang,NumBoxLen,NumBoxWit):
  # ------------------------------------------------------------------------------
  # create the main segment - no rotation
  # Translate to centre origin cartesian and radians
  #   x1 = x-(w/2); 
  #   y1 = -(y-(h/2));
  #theta = theta*PI/180;
  # Rotate point	
  #x2 = (x1*cos(theta))-(y1*sin(theta));
  #y2 = (x1*sin(theta))+(y1*cos(theta));
  #Translate back to imageJ coordinates
  #x2 = x2 + (w/2); 
  #y2 = (h/2)-y2;  
  # ------------------------------------------------------------------------------
  if None == Store or None == imageset:
    print "No Measurements available [MA_Compute_Main_Boxes]" 
    return None   
  # ------------------------------------------------------------------------------ 
  #Height = int(Math.sqrt(Math.pow(float(BBox.x),2.0) + Math.pow(float(BBox.y),2.0)))
  #if 0>= Horiz or 0>= Vert:
  #  print "Error [MA_Compute_Main_Boxes]" 
  #  return None,-1   
  # ------------------------------------------------------------------------------ 
  if BBox.x >= BBox.y :  # horizontal side > vertical side
    Horiz = longBB
    Vert = shortBB
  else:  
    Horiz = shortBB
    Vert = longBB 
  # ------------------------------------------------------------------------------
  # create main polyline Edges
  # ------------------------------------------------------------------------------
  rectLeft = int(Centroide.x - (Horiz/2))
  rectTop = int(Centroide.y - (Vert/2))
  rectRight = int(Centroide.x + (Horiz/2))
  rectBottom = int(Centroide.y + (Vert/2))
  # ------------------------------------------------------------------------------  
  #print "rectLeft: " + str(rectLeft) + " rectTop: " + str(rectTop)+ " rectRight: " + str(rectRight) + " rectBottom: " + str(rectBottom)  # DEBUG
  # ------------------------------------------------------------------------------  
  polyline = [core.Point2D(rectLeft, rectTop), core.Point2D(rectRight, rectTop), core.Point2D(rectRight, rectBottom), core.Point2D(rectLeft, rectBottom), core.Point2D(rectLeft, rectTop)]
  polyline_Rotate = polyline
  Start_point = polyline[0]
  # ------------------------------------------------------------------------------  
  # rotazione segmento
  # ------------------------------------------------------------------------------   
  Inverti = False
  if Ang >= -45.0 and Ang <= 0.0:
    # ------------------------------------------------------------------------------   
    theta =  abs(Ang) * Math.pi /180.0      # ok
    # ------------------------------------------------------------------------------   
  elif Ang > 0.0 and Ang <= 45.0:
    # ------------------------------------------------------------------------------   
    theta =  -Ang * Math.pi /180.0
    # ------------------------------------------------------------------------------   
  elif Ang >= -90.0 and Ang < -45.0:         # ok
    # ------------------------------------------------------------------------------   
    theta =  (90 + abs(Ang)) * Math.pi /180.0
    tempor = NumBoxLen
    NumBoxLen = NumBoxWit
    NumBoxWit = tempor
    Inverti = True
    # ------------------------------------------------------------------------------   
  else: 
    # ------------------------------------------------------------------------------   
    theta =  (90 - abs(Ang)) * Math.pi /180.0
    tempor = NumBoxLen
    NumBoxLen = NumBoxWit
    NumBoxWit = tempor
    Inverti = True
  # ------------------------------------------------------------------------------
  # the single size box is computed
  #
  # ------------------------------------------------------------------------------
  if SIZE_IN_VOXELS == False:
    Size_Box_H,Size_Box_V = MA_Compute_SizeXY_Boxes(Horiz,Vert,NumBoxLen,NumBoxWit)
  else:
    Size_Box_H,Size_Box_V = MA_Compute_MetricSizeXY_Boxes(imageset)    
    if BBox.x > BBox.y :  # horizontal side > vertical side
      Tempo = Size_Box_H
      Size_Box_H = Size_Box_V
      Size_Box_V = Tempo
      Start_point.y = Start_point.y - (Size_Box_V/2) + (abs(rectBottom - rectTop) / 2)
    else:  
      Start_point.x = Start_point.x - (Size_Box_H/2) + (abs(rectRight - rectLeft) / 2)
  # ------------------------------------------------------------------------------
  #print "Horiz: " + str(Horiz) + " Vert: " + str(Vert) # DEBUG
  # ------------------------------------------------------------------------------   
  #print "Size_Box_H: " + str(Size_Box_H) + " Size_Box_V: " + str(Size_Box_V)  # DEBUG
  # ------------------------------------------------------------------------------
  # create subaree polyline Edges
  # POLYGONE_ENTRIES -  order  LT,RT,RB,LB,LT
  # ------------------------------------------------------------------------------  
  Multipoly = [core.Point2D]
  del Multipoly[0]
  # ------------------------------------------------------------------------------ 
  for l in range(0,NUM_BOX_WIDTH):
    # ------------------------------------------------------------------------------  
    for w in range(0,NUM_BOX_LENGHT):
      # ------------------------------------------------------------------------------     
      if False == Inverti:
        Lf = Start_point.x + (Size_Box_H * w) 
        Tp =  Start_point.y + (Size_Box_V * l)        
      else:
        Lf = Start_point.x + (Size_Box_H * l)
        Tp =  Start_point.y + (Size_Box_V * w)      
      # ------------------------------------------------------------------------------     
      Rg = Lf + Size_Box_H 
      Bm = Tp + Size_Box_V           
      # ------------------------------------------------------------------------------     
      Multipoly.append(core.Point2D(Lf,Tp))
      Multipoly.append(core.Point2D(Rg,Tp))
      Multipoly.append(core.Point2D(Rg,Bm))
      Multipoly.append(core.Point2D(Lf,Bm))             
      #print "rectLeft1: " + str(Lf) + " rectTop1: " + str(Tp)+ " rectRight1: " + str(Rg) + " rectBottom1: " + str(Bm)  # DEBUG
  # ------------------------------------------------------------------------------     
  if True== COMPUTE_MAIN_BOX:
  # ------------------------------------------------------------------------------         
    for indice in range(0,len(polyline)):
      # ------------------------------------------------------------------------------ 
      pts2D = polyline[indice]
      # ------------------------------------------------------------------------------ 
      # Translate to centre origin cartesian and radians
      # ------------------------------------------------------------------------------ 
      x1 = int(pts2D.x - Centroide.x)
      y1 = -int(pts2D.y - Centroide.y) 
      # Rotate point
      x2 = (x1*Math.cos(theta))-(y1*Math.sin(theta))
      y2 = (x1*Math.sin(theta))+(y1*Math.cos(theta))
      # Translate back to image coordinates
      pts2D.x = x2 + Centroide.x
      pts2D.y = Centroide.y-y2    
      # ------------------------------------------------------------------------------  
      polyline_Rotate[indice] = pts2D
    # ------------------------------------------------------------------------------    
    polygon = objects.Polygon()
    polygon.set_contour(polyline_Rotate)         # polyline
    # ------------------------------------------------------------------------------  
    boxObject = objects.Segment()
    # ------------------------------------------------------------------------------  
    for z in range(firstP, lastP) :
      #------------------------------------------------------------------------------		
      boxObject.add_polygon(polygon, z)
    # ------------------------------------------------------------------------------  
    Store.add_object(boxObject)  
    IdList = Store.get_object_ids(TAG_DESCRIPTOR_OUT)
    Oggetto1 = Get_Object(Store,IdList[len(IdList)-1])  
    IDobject1 = Oggetto.get_id()  
  # ------------------------------------------------------------------------------  
  # rotazione singoli segmenti
  # ------------------------------------------------------------------------------    
  for indiceM in range(0,len(Multipoly)-1,POLYGONE_ENTRIES):
    # ------------------------------------------------------------------------------ 
    Singlepoly = [core.Point2D]
    del Singlepoly[0]
    # ------------------------------------------------------------------------------ 
    for indiceS in range(0,POLYGONE_ENTRIES):
      # ------------------------------------------------------------------------------     
      #print "Multipoly 1 : " + str(Multipoly[indiceM + indiceS])       
      pts2D_1 = Multipoly[indiceM + indiceS]
      # ------------------------------------------------------------------------------ 
      # Translate to centre origin cartesian and radians
      # ------------------------------------------------------------------------------ 
      x1 = int(pts2D_1.x - Centroide.x)
      y1 = -int(pts2D_1.y - Centroide.y) 
      # Rotate point
      x2 = (x1*Math.cos(theta))-(y1*Math.sin(theta))
      y2 = (x1*Math.sin(theta))+(y1*Math.cos(theta))
      # Translate back to image coordinates
      pts2D_1.x = x2 + Centroide.x
      pts2D_1.y = Centroide.y-y2    
      # ------------------------------------------------------------------------------  
      Singlepoly.append(pts2D_1)    
    # ------------------------------------------------------------------------------ 
    Singlepoly.append(Singlepoly[0])
    #print "Singlepoly  : " + str(len(Singlepoly) )
    # ------------------------------------------------------------------------------    
    polygon1 = objects.Polygon()
    polygon1.set_contour(Singlepoly)         # polyline
    # ------------------------------------------------------------------------------  
    boxObject1 = objects.Segment()
    # ------------------------------------------------------------------------------  
    for z in range(firstP, lastP) :
      #------------------------------------------------------------------------------		
      boxObject1.add_polygon(polygon1, z)
      # ------------------------------------------------------------------------------  
    Store.add_object(boxObject1)  
    IdList = Store.get_object_ids(TAG_DESCRIPTOR_OUT)
    Oggetto2 = Get_Object(Store,IdList[len(IdList)-1])  
    IDobject2 = Oggetto.get_id()  
  #------------------------------------------------------------------------------  
  # debug
  #------------------------------------------------------------------------------  
  #print "IDobject2 " + str(IDobject2) 
  return Oggetto2,IDobject2
# ------------------------------ Script body ----------------------------------- 
# End Function : MA_Compute_Multi_Boxes
# ------------------------------------------------------------------------------ 
#
# ------------------------------ Script body ----------------------------------- 
# Main body
# ------------------------------------------------------------------------------    
# helper to get execution time
startTime = time.time()
# ------------------------------------------------------------------------------  
viewer,imageset = MA_Get_Enviroment()          
Store = MA_Get_Storage(imageset)
# ------------------------------------------------------------------------------            
if None != Store :
  # ---------------------------------------------------------------------------- TOTAL_PLANES
  Planes = core.ImageSet.get_plane_count(imageset)
  print "Planes: " + str(Planes)
  IdList = Store.get_object_ids(TAG_DESCRIPTOR)
  print "Id: " + str(IdList)
  #------------------------------------------------------------------------------  
  FirstPlane = 0
  LastPlane = Planes - 1
  planeCount = imageset.get_plane_count()
  #------------------------------------------------------------------------------  
  #  loop on ID list
  #------------------------------------------------------------------------------    
  #if 0 < int(len(IdList)):
  for indice in range(0,int(len(IdList))): 
    # ------------------------------------------------------------------------------
    #print "ID " + str(IdList[indice])
    Oggetto = Get_Object(Store,IdList[indice])    
    # ------------------------------------------------------------------------------ 
    Centroide_2D = Get_Object_2DBB_Centroid(imageset,Store,IdList[indice],TAG_DESCRIPTOR,True)
    BBox = Get_Object_BB_Size(Store,IdList[indice],TAG_DESCRIPTOR)
    Seg_Plane = Get_Object_Plane_Range(Store,IdList[indice],TAG_DESCRIPTOR)
    AngleXY = Get_Object_2DBB_Angle(Store,IdList[indice],TAG_DESCRIPTOR)
    shortBB,longBB = Get_Object_2DBB_Size(imageset,Store,IdList[indice],TAG_DESCRIPTOR,True)
    # ------------------------------------------------------------------------------  
    if -1>=FIRST_PLANE :
      FIRST_PLANE = 0
    if -1>=LAST_PLANE or LAST_PLANE > planeCount-1 :
      LAST_PLANE = planeCount-1    
    if FIRST_PLANE > LAST_PLANE :          
      TempPlane = FIRST_PLANE   
      FIRST_PLANE = LAST_PLANE
      LAST_PLANE = TempPlane
    # ------------------------------------------------------------------------------  
    segment = MA_Compute_Multi_Boxes(imageset,Store,Centroide_2D,BBox,FIRST_PLANE,LAST_PLANE,AngleXY,NUM_BOX_LENGHT,NUM_BOX_WIDTH)
    # ------------------------------------------------------------------------------
     
# ------------------------------------------------------------------------------              
# ------------------------------------------------------------------------------ 

# ------------------------------------------------------------------------------            
endTime = time.time()
print "time: " + str(endTime - startTime)
# ------------------------------ Script body ----------------------------------- 
# End of main body
# ------------------------------------------------------------------------------    